const gameState = { operation: 'add', difficulty: 1, score: 0, timeLeft: 60, currentProblem: null, currentAnswer: '', timerInterval: null };
function generateProblem() { const diff = parseInt(document.getElementById('difficulty').value); let min, max; switch(diff) { case 1: min = 1; max = 10; break; case 2: min = 10; max = 50; break; case 3: min = 50; max = 150; break; case 4: min = 100; max = 1000; break; } const operation = document.getElementById('operationType').value; let ops = operation === 'mixed' ? ['add', 'subtract', 'multiply', 'divide'] : [operation]; const selectedOp = ops[Math.floor(Math.random() * ops.length)]; let num1, num2, answer, question, symbol; switch(selectedOp) { case 'add': num1 = Math.floor(Math.random() * (max - min + 1)) + min; num2 = Math.floor(Math.random() * (max - min + 1)) + min; answer = num1 + num2; symbol = '+'; break; case 'subtract': num1 = Math.floor(Math.random() * (max - min + 1)) + min; num2 = Math.floor(Math.random() * (max - min + 1)) + min; if (num1 < num2) [num1, num2] = [num2, num1]; answer = num1 - num2; symbol = '-'; break; case 'multiply': const multMax = Math.floor(Math.sqrt(max)); num1 = Math.floor(Math.random() * multMax) + 1; num2 = Math.floor(Math.random() * multMax) + 1; answer = num1 * num2; symbol = '×'; break; case 'divide': num2 = Math.floor(Math.random() * 10) + 1; answer = Math.floor(Math.random() * 20) + 1; num1 = num2 * answer; symbol = '÷'; break; } question = `${num1} ${symbol} ${num2} = ?`; return { question, answer }; }
function displayProblem() { const problem = generateProblem(); gameState.currentProblem = problem; gameState.currentAnswer = ''; const problemDiv = document.getElementById('problem'); problemDiv.innerHTML = `<div class="problem-text">${problem.question}</div><div class="answer-input" id="answer">_</div>`; }
function createNumberPad() { const keyboardDiv = document.getElementById('keyboard'); const buttons = ['7', '8', '9', '4', '5', '6', '1', '2', '3', '-', '0', 'C']; keyboardDiv.innerHTML = ''; buttons.forEach(btn => { const button = document.createElement('button'); button.className = 'number-btn'; if (btn === 'C') button.classList.add('clear-btn'); button.textContent = btn; button.onclick = () => handleNumberInput(btn); keyboardDiv.appendChild(button); }); const submitBtn = document.createElement('button'); submitBtn.className = 'number-btn submit-btn'; submitBtn.textContent = '✓ Javobni Yuborish'; submitBtn.onclick = () => submitAnswer(); keyboardDiv.appendChild(submitBtn); }
function handleNumberInput(value) { if (value === 'C') { gameState.currentAnswer = ''; } else if (value === '-') { if (gameState.currentAnswer === '') { gameState.currentAnswer = '-'; } } else { gameState.currentAnswer += value; } document.getElementById('answer').textContent = gameState.currentAnswer || '_'; }
function startTimer() { gameState.timerInterval = setInterval(() => { gameState.timeLeft--; document.getElementById('timer').textContent = gameState.timeLeft; if (gameState.timeLeft <= 0) { endGame(); } }, 1000); }
function submitAnswer() { const userAnswer = parseInt(gameState.currentAnswer); const correctAnswer = gameState.currentProblem.answer; if (isNaN(userAnswer)) { alert('Iltimos, javobni kiriting!'); return; } const problemDiv = document.getElementById('problem'); if (userAnswer === correctAnswer) { problemDiv.classList.add('correct-answer'); setTimeout(() => problemDiv.classList.remove('correct-answer'), 300); gameState.score++; document.getElementById('score').textContent = gameState.score; displayProblem(); } else { problemDiv.classList.add('wrong-answer'); setTimeout(() => problemDiv.classList.remove('wrong-answer'), 300); gameState.currentAnswer = ''; document.getElementById('answer').textContent = '_'; } }
function endGame() { clearInterval(gameState.timerInterval); const resultContent = document.getElementById('resultContent'); resultContent.innerHTML = `<div class="winner-emoji">⚡</div><div class="winner-text">Vaqt Tugadi!</div><div class="result-stats"><div class="stat-row"><span class="stat-label">To'plangan Ball:</span><span class="stat-value">${gameState.score}</span></div></div>`; document.getElementById('gameScreen').classList.remove('active'); document.getElementById('resultScreen').classList.add('active'); }
function startGame() { const operation = document.getElementById('operationType').value; const difficulty = document.getElementById('difficulty').value; gameState.operation = operation; gameState.difficulty = difficulty; gameState.score = 0; gameState.timeLeft = 60; document.getElementById('score').textContent = '0'; document.getElementById('timer').textContent = '60'; createNumberPad(); displayProblem(); startTimer(); document.getElementById('setupScreen').classList.remove('active'); document.getElementById('gameScreen').classList.add('active'); }
function restartGame() { document.getElementById('resultScreen').classList.remove('active'); document.getElementById('setupScreen').classList.add('active'); }
function goHome() { window.location.href = '../index.php'; }
function showHelp() { document.getElementById('helpModal').classList.add('active'); }
function closeHelp() { document.getElementById('helpModal').classList.remove('active'); }
document.addEventListener('keydown', (e) => { if (e.key === 'Escape') { closeHelp(); } });
document.getElementById('helpModal').addEventListener('click', (e) => { if (e.target.id === 'helpModal') { closeHelp(); } });
