// Game State
const gameState = {
    difficulty: 1,
    correctScore: 0,
    wrongScore: 0,
    currentProblem: { left: 0, right: 0, correctSymbol: '' }
};

// Initialize game
window.addEventListener('DOMContentLoaded', () => {
    // No special initialization needed
});

// Generate comparison problem
function generateProblem() {
    const diff = parseInt(document.getElementById('difficulty').value);
    let min, max;

    switch(diff) {
        case 1: min = 1; max = 10; break;
        case 2: min = 10; max = 100; break;
        case 3: min = 100; max = 1000; break;
        case 4: min = 1000; max = 10000; break;
    }

    let left = Math.floor(Math.random() * (max - min + 1)) + min;
    let right = Math.floor(Math.random() * (max - min + 1)) + min;

    // Sometimes make them equal for variety
    if (Math.random() < 0.15) {
        right = left;
    }

    let correctSymbol;
    if (left < right) {
        correctSymbol = '<';
    } else if (left > right) {
        correctSymbol = '>';
    } else {
        correctSymbol = '=';
    }

    return { left, right, correctSymbol };
}

// Display problem
function displayProblem() {
    const problem = generateProblem();
    gameState.currentProblem = problem;

    document.getElementById('leftNumber').textContent = problem.left;
    document.getElementById('rightNumber').textContent = problem.right;
    document.getElementById('symbolDisplay').textContent = '?';
}

// Check comparison
function checkComparison(symbol) {
    const correct = symbol === gameState.currentProblem.correctSymbol;
    const symbolDisplay = document.getElementById('symbolDisplay');

    symbolDisplay.textContent = symbol;

    if (correct) {
        gameState.correctScore++;
        document.getElementById('correctScore').textContent = gameState.correctScore;

        symbolDisplay.classList.add('correct');
        setTimeout(() => {
            symbolDisplay.classList.remove('correct');
            generateNewProblem();
        }, 1000);
    } else {
        gameState.wrongScore++;
        document.getElementById('wrongScore').textContent = gameState.wrongScore;

        symbolDisplay.classList.add('wrong');
        setTimeout(() => {
            symbolDisplay.classList.remove('wrong');
            symbolDisplay.textContent = gameState.currentProblem.correctSymbol;
            setTimeout(() => {
                generateNewProblem();
            }, 1500);
        }, 500);
    }
}

// Generate new problem
function generateNewProblem() {
    displayProblem();
}

// Start game
function startGame() {
    const difficulty = document.getElementById('difficulty').value;
    gameState.difficulty = difficulty;
    gameState.correctScore = 0;
    gameState.wrongScore = 0;

    document.getElementById('correctScore').textContent = '0';
    document.getElementById('wrongScore').textContent = '0';

    displayProblem();

    document.getElementById('setupScreen').classList.remove('active');
    document.getElementById('gameScreen').classList.add('active');
}

// Restart game
function restartGame() {
    document.getElementById('resultScreen').classList.remove('active');
    document.getElementById('setupScreen').classList.add('active');
}

// Go home
function goHome() {
    window.location.href = '../index.php';
}

// Pause game
function pauseGame() {
    if (confirm('O\'yinni to\'xtatmoqchimisiz?')) {
        document.getElementById('gameScreen').classList.remove('active');
        document.getElementById('setupScreen').classList.add('active');
    }
}

// Show help
function showHelp() {
    document.getElementById('helpModal').classList.add('active');
}

// Close help
function closeHelp() {
    document.getElementById('helpModal').classList.remove('active');
}

// Close modal on ESC
document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape') {
        closeHelp();
    }
});

// Close modal on outside click
document.getElementById('helpModal').addEventListener('click', (e) => {
    if (e.target.id === 'helpModal') {
        closeHelp();
    }
});
