<!DOCTYPE html>
<html lang="uz">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="description" content="O'zbek tilida matematika o'yinlari - Bolalar va o'smirlar uchun interaktiv ta'lim platformasi">
    <meta name="keywords" content="matematika, o'yinlar, ta'lim, o'zbek tili, bolalar">
    <title>Matematika O'yinlari - Interaktiv Ta'lim Platformasi</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        :root {
            --primary-bg: #0a0e27;
            --secondary-bg: #141b3d;
            --card-bg: #1e2749;
            --blue-team: #3b82f6;
            --red-team: #ef4444;
            --purple: #8b5cf6;
            --green: #10b981;
            --yellow: #f59e0b;
            --orange: #fb923c;
            --pink: #ec4899;
            --cyan: #06b6d4;
            --text-primary: #f1f5f9;
            --text-secondary: #cbd5e1;
            --glass-bg: rgba(255, 255, 255, 0.05);
            --glass-border: rgba(255, 255, 255, 0.1);
        }

        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-20px); }
        }

        @keyframes glow {
            0%, 100% { box-shadow: 0 0 20px rgba(139, 92, 246, 0.3); }
            50% { box-shadow: 0 0 40px rgba(139, 92, 246, 0.6); }
        }

        @keyframes gradient {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }

        @keyframes slideInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes shimmer {
            0% { background-position: -1000px 0; }
            100% { background-position: 1000px 0; }
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Roboto', 'Oxygen', 'Ubuntu', 'Cantarell', sans-serif;
            background: linear-gradient(135deg, var(--primary-bg) 0%, var(--secondary-bg) 100%);
            background-attachment: fixed;
            color: var(--text-primary);
            min-height: 100vh;
            overflow-x: hidden;
            touch-action: manipulation;
            position: relative;
        }

        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background:
                radial-gradient(circle at 20% 30%, rgba(139, 92, 246, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 80% 70%, rgba(59, 130, 246, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 50% 50%, rgba(16, 185, 129, 0.05) 0%, transparent 50%);
            pointer-events: none;
            z-index: 0;
        }

        .container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 20px;
            position: relative;
            z-index: 1;
        }

        .top-actions {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1000;
            display: flex;
            gap: 10px;
        }

        .action-btn {
            background: var(--glass-bg);
            backdrop-filter: blur(10px);
            border: 2px solid var(--glass-border);
            padding: 12px 20px;
            border-radius: 12px;
            color: var(--text-primary);
            cursor: pointer;
            font-size: 16px;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 8px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
        }

        .action-btn:hover {
            background: var(--purple);
            border-color: var(--purple);
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(139, 92, 246, 0.4);
        }

        .action-btn:active {
            transform: translateY(0);
        }

        header {
            text-align: center;
            padding: 50px 20px;
            background: linear-gradient(135deg, var(--purple) 0%, var(--blue-team) 50%, var(--cyan) 100%);
            background-size: 200% 200%;
            animation: gradient 15s ease infinite;
            border-radius: 25px;
            margin-bottom: 40px;
            box-shadow: 0 20px 60px rgba(139, 92, 246, 0.4);
            border: 2px solid var(--glass-border);
            position: relative;
            overflow: hidden;
        }

        header::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: repeating-linear-gradient(
                45deg,
                transparent,
                transparent 10px,
                rgba(255, 255, 255, 0.03) 10px,
                rgba(255, 255, 255, 0.03) 20px
            );
            animation: shimmer 20s linear infinite;
        }

        h1 {
            font-size: clamp(32px, 5vw, 56px);
            margin-bottom: 15px;
            text-shadow: 0 0 20px rgba(255, 255, 255, 0.3), 2px 2px 8px rgba(0, 0, 0, 0.5);
            position: relative;
            z-index: 1;
            font-weight: 800;
            letter-spacing: -0.5px;
        }

        .subtitle {
            font-size: clamp(16px, 2.5vw, 22px);
            color: rgba(255, 255, 255, 0.9);
            margin-bottom: 35px;
            position: relative;
            z-index: 1;
            font-weight: 300;
        }

        .mode-selection {
            display: flex;
            gap: 20px;
            justify-content: center;
            flex-wrap: wrap;
            margin-bottom: 30px;
        }

        .mode-btn {
            background: rgba(255, 255, 255, 0.1);
            border: 3px solid transparent;
            padding: 20px 40px;
            border-radius: 15px;
            cursor: pointer;
            font-size: clamp(16px, 2vw, 20px);
            color: var(--text-primary);
            transition: all 0.3s ease;
            backdrop-filter: blur(10px);
            min-width: 200px;
        }

        .mode-btn:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(255, 255, 255, 0.2);
        }

        .mode-btn.active {
            border-color: var(--green);
            background: rgba(16, 185, 129, 0.2);
        }

        .mode-btn.solo {
            border-color: var(--blue-team);
        }

        .mode-btn.team {
            border-color: var(--red-team);
        }

        .info-section {
            background: var(--glass-bg);
            backdrop-filter: blur(10px);
            padding: 35px;
            border-radius: 20px;
            margin-bottom: 40px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
            border: 2px solid var(--glass-border);
            animation: slideInUp 0.5s ease forwards;
        }

        .info-section h2 {
            color: var(--yellow);
            margin-bottom: 20px;
            font-size: clamp(20px, 3vw, 28px);
        }

        .info-section p {
            line-height: 1.8;
            color: var(--text-secondary);
            font-size: clamp(14px, 1.5vw, 16px);
        }

        .games-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 25px;
            margin-bottom: 40px;
        }

        .game-card {
            background: var(--glass-bg);
            backdrop-filter: blur(10px);
            padding: 30px;
            border-radius: 20px;
            cursor: pointer;
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            border: 2px solid var(--glass-border);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.3);
            position: relative;
            overflow: hidden;
            animation: slideInUp 0.6s ease forwards;
        }

        .game-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.1), transparent);
            transition: left 0.5s;
        }

        .game-card:hover::before {
            left: 100%;
        }

        .game-card:hover {
            transform: translateY(-15px) scale(1.02);
            border-color: var(--purple);
            box-shadow: 0 20px 50px rgba(139, 92, 246, 0.5);
            background: linear-gradient(135deg, rgba(139, 92, 246, 0.1), rgba(59, 130, 246, 0.1));
        }

        .game-card.disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }

        .game-card.disabled:hover {
            transform: none;
            border-color: transparent;
        }

        .game-icon {
            font-size: 64px;
            margin-bottom: 20px;
            display: block;
            filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.3));
            animation: float 3s ease-in-out infinite;
            position: relative;
            z-index: 1;
        }

        .game-title {
            font-size: clamp(20px, 2vw, 24px);
            margin-bottom: 12px;
            color: var(--text-primary);
            font-weight: 700;
            position: relative;
            z-index: 1;
        }

        .game-description {
            font-size: clamp(12px, 1.5vw, 14px);
            color: var(--text-secondary);
            line-height: 1.6;
            margin-bottom: 10px;
        }

        .game-tags {
            display: flex;
            gap: 8px;
            flex-wrap: wrap;
            margin-top: 15px;
        }

        .tag {
            background: rgba(255, 255, 255, 0.1);
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 12px;
            color: var(--text-secondary);
        }

        .tag.solo-tag {
            background: rgba(59, 130, 246, 0.2);
            color: var(--blue-team);
        }

        .tag.team-tag {
            background: rgba(239, 68, 68, 0.2);
            color: var(--red-team);
        }

        .features-section {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 40px;
        }

        .feature-box {
            background: var(--glass-bg);
            backdrop-filter: blur(10px);
            padding: 30px;
            border-radius: 20px;
            text-align: center;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.3);
            border: 2px solid var(--glass-border);
            transition: all 0.3s ease;
            animation: slideInUp 0.7s ease forwards;
        }

        .feature-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 30px rgba(139, 92, 246, 0.3);
            border-color: var(--purple);
        }

        .feature-box h3 {
            color: var(--green);
            margin-bottom: 10px;
            font-size: clamp(16px, 2vw, 20px);
        }

        .feature-box p {
            color: var(--text-secondary);
            font-size: clamp(12px, 1.5vw, 14px);
        }

        footer {
            background: var(--glass-bg);
            backdrop-filter: blur(10px);
            padding: 40px;
            border-radius: 20px;
            text-align: center;
            margin-top: 60px;
            border: 2px solid var(--glass-border);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
        }

        .developer-info {
            margin-bottom: 20px;
        }

        .developer-info h3 {
            color: var(--purple);
            margin-bottom: 10px;
        }

        .social-links {
            display: flex;
            gap: 20px;
            justify-content: center;
            flex-wrap: wrap;
            margin-top: 15px;
        }

        .social-link {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 14px 28px;
            background: var(--glass-bg);
            backdrop-filter: blur(10px);
            border: 2px solid var(--glass-border);
            border-radius: 12px;
            color: var(--text-primary);
            text-decoration: none;
            transition: all 0.3s ease;
            font-weight: 600;
        }

        .social-link:hover {
            background: linear-gradient(135deg, var(--purple), var(--pink));
            border-color: var(--purple);
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(139, 92, 246, 0.4);
        }

        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.8);
            z-index: 1000;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .modal.active {
            display: flex;
        }

        .modal-content {
            background: var(--secondary-bg);
            padding: 40px;
            border-radius: 20px;
            max-width: 600px;
            width: 100%;
            max-height: 80vh;
            overflow-y: auto;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.5);
        }

        .modal-content h2 {
            color: var(--yellow);
            margin-bottom: 20px;
        }

        .modal-content h3 {
            color: var(--green);
            margin-top: 20px;
            margin-bottom: 10px;
        }

        .close-btn {
            float: right;
            font-size: 28px;
            cursor: pointer;
            color: var(--text-secondary);
            transition: color 0.3s ease;
        }

        .close-btn:hover {
            color: var(--red-team);
        }

        .difficulty-levels {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
            gap: 10px;
            margin: 20px 0;
        }

        .difficulty-badge {
            padding: 10px;
            border-radius: 10px;
            text-align: center;
            font-size: 14px;
            font-weight: bold;
        }

        .difficulty-1 { background: rgba(16, 185, 129, 0.2); color: var(--green); }
        .difficulty-2 { background: rgba(245, 158, 11, 0.2); color: var(--yellow); }
        .difficulty-3 { background: rgba(239, 68, 68, 0.2); color: var(--red-team); }
        .difficulty-4 { background: rgba(139, 92, 246, 0.2); color: var(--purple); }

        .btn-primary {
            background: linear-gradient(135deg, var(--purple), var(--blue-team));
            color: white;
            border: none;
            padding: 15px 40px;
            border-radius: 10px;
            font-size: 18px;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 5px 15px rgba(139, 92, 246, 0.3);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(139, 92, 246, 0.5);
        }

        @media (max-width: 768px) {
            .top-actions {
                top: 10px;
                right: 10px;
            }

            .action-btn {
                padding: 10px 16px;
                font-size: 14px;
            }

            header {
                padding: 35px 20px;
                margin-bottom: 30px;
            }

            .mode-btn {
                padding: 16px 32px;
                min-width: 160px;
            }

            .games-grid {
                grid-template-columns: repeat(auto-fill, minmax(240px, 1fr));
                gap: 18px;
            }

            .game-card {
                padding: 25px;
            }

            .game-icon {
                font-size: 56px;
            }

            .info-section, .feature-box, footer {
                padding: 25px;
            }

            .modal-content {
                padding: 30px;
            }
        }

        @media (max-width: 480px) {
            .container {
                padding: 15px;
            }

            .top-actions {
                position: relative;
                top: 0;
                right: 0;
                margin-bottom: 15px;
                justify-content: center;
            }

            .action-btn {
                font-size: 13px;
                padding: 10px 16px;
            }

            .games-grid {
                grid-template-columns: 1fr;
            }

            .game-icon {
                font-size: 52px;
            }

            .mode-selection {
                flex-direction: column;
                gap: 15px;
            }

            .mode-btn {
                width: 100%;
            }

            .features-section {
                grid-template-columns: 1fr;
            }
        }

        .loading {
            text-align: center;
            padding: 20px;
        }

        .loading-spinner {
            border: 4px solid rgba(255, 255, 255, 0.1);
            border-left-color: var(--purple);
            border-radius: 50%;
            width: 50px;
            height: 50px;
            animation: spin 1s linear infinite;
            margin: 0 auto;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        .scroll-top {
            position: fixed;
            bottom: 30px;
            right: 30px;
            background: var(--purple);
            color: white;
            width: 50px;
            height: 50px;
            border-radius: 50%;
            display: none;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            font-size: 24px;
            box-shadow: 0 5px 15px rgba(139, 92, 246, 0.4);
            transition: all 0.3s ease;
            z-index: 999;
        }

        .scroll-top.visible {
            display: flex;
        }

        .scroll-top:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(139, 92, 246, 0.6);
        }
    </style>
</head>
<body>
    <!-- Top Action Buttons -->
    <div class="top-actions">
        <a href="download-zip.php" class="action-btn" title="Barcha kodlarni yuklab olish">
            📦 ZIP Yuklab Olish
        </a>
    </div>

    <div class="container">
        <header>
            <h1>🎓 Matematika O'yinlari</h1>
            <p class="subtitle">Interaktiv Ta'lim Platformasi - O'rganish Qiziqarli Bo'lsin!</p>

            <div class="mode-selection">
                <button class="mode-btn solo active" onclick="selectMode('solo')">
                    👤 Yolg'iz Rejim
                </button>
                <button class="mode-btn team" onclick="selectMode('team')">
                    👥 Jamoa Rejimi
                </button>
            </div>
        </header>

        <div class="info-section">
            <h2>📚 Platforma Haqida</h2>
            <p>
                <strong>Matematika O'yinlari</strong> - bu o'zbek tilida yaratilgan interaktiv ta'lim platformasi bo'lib,
                bolalar va o'smirlar uchun matematikani qiziqarli va samarali o'rganish imkonini beradi.
                Loyiha 16 ta turli xil matematik o'yinni o'z ichiga oladi va ikkita asosiy rejimda ishlaydi:
                <strong>Yolg'iz</strong> va <strong>Jamoa</strong>.
            </p>
        </div>

        <div class="features-section">
            <div class="feature-box">
                <h3>🎮 16 Ta O'yin</h3>
                <p>Turli darajadagi matematik o'yinlar</p>
            </div>
            <div class="feature-box">
                <h3>📊 4 Ta Daraja</h3>
                <p>Oson, O'rta, Qiyin, Juda Qiyin</p>
            </div>
            <div class="feature-box">
                <h3>👥 Jamoa Rejimi</h3>
                <p>Do'stlar bilan raqobatlashing</p>
            </div>
            <div class="feature-box">
                <h3>📱 Responsive</h3>
                <p>Barcha qurilmalarda ishlaydi</p>
            </div>
        </div>

        <h2 style="text-align: center; color: var(--yellow); margin-bottom: 30px; font-size: clamp(24px, 4vw, 32px);">
            🎯 O'yinlar Ro'yxati
        </h2>

        <div id="games-grid" class="games-grid">
            <!-- Games will be loaded here by JavaScript -->
        </div>

        <footer>
            <div class="developer-info">
                <h3>👨‍💻 Dasturchi Ma'lumotlari</h3>
                <p><strong>Muallif:</strong> Bahodirov Dilxush</p>
                <div class="social-links">
                    <a href="https://instagram.com/dilxush_bahodirov" target="_blank" class="social-link">
                        📷 Instagram
                    </a>
                    <a href="https://t.me/dilxush_bahodirov" target="_blank" class="social-link">
                        ✈️ Telegram
                    </a>
                </div>
            </div>
            <p style="color: var(--text-secondary); margin-top: 20px; font-size: 14px;">
                © 2024 Matematika O'yinlari - Barcha huquqlar himoyalangan
            </p>
        </footer>
    </div>

    <div class="scroll-top" id="scrollTop" onclick="scrollToTop()">
        ↑
    </div>

    <!-- Game Info Modal -->
    <div id="gameModal" class="modal">
        <div class="modal-content">
            <span class="close-btn" onclick="closeModal()">&times;</span>
            <div id="modalContent">
                <!-- Game details will be loaded here -->
            </div>
        </div>
    </div>

    <script>
        // Game mode management
        let currentMode = localStorage.getItem('playMode') || 'solo';

        function selectMode(mode) {
            currentMode = mode;
            localStorage.setItem('playMode', mode);

            document.querySelectorAll('.mode-btn').forEach(btn => {
                btn.classList.remove('active');
            });
            document.querySelector(`.mode-btn.${mode}`).classList.add('active');

            loadGames();
        }

        // Games data
        const games = [
            {
                id: 1,
                icon: '🏆',
                name: 'Arqon Tortish',
                description: 'Matematik savollar orqali arqon tortish',
                modes: ['solo', 'team'],
                difficulty: 4,
                folder: 'oyin1'
            },
            {
                id: 2,
                icon: '🧗',
                name: "Marraga Ko'tarilish",
                description: "Cho'qqiga birinchi chiqish",
                modes: ['solo', 'team'],
                difficulty: 4,
                folder: 'oyin2'
            },
            {
                id: 3,
                icon: '🏁',
                name: 'Poyga',
                description: 'Manzilga birinchi yetish',
                modes: ['solo', 'team'],
                difficulty: 4,
                folder: 'oyin3'
            },
            {
                id: 4,
                icon: '⚖️',
                name: 'Taqqoslash',
                description: 'Sonlarni taqqoslash',
                modes: ['solo'],
                difficulty: 4,
                folder: 'oyin4'
            },
            {
                id: 5,
                icon: '🧠',
                name: 'Xotira',
                description: 'Masalalarni eslab qolish',
                modes: ['solo'],
                difficulty: 4,
                folder: 'oyin5'
            },
            {
                id: 6,
                icon: '⚡',
                name: 'Tezlik',
                description: 'Vaqt chegarasida javob berish',
                modes: ['solo'],
                difficulty: 4,
                folder: 'oyin6'
            },
            {
                id: 7,
                icon: '🔢',
                name: 'Ketma-ketlik',
                description: 'Sonlar ketma-ketligini davom ettirish',
                modes: ['solo', 'team'],
                difficulty: 4,
                folder: 'oyin7'
            },
            {
                id: 8,
                icon: '🎲',
                name: 'Topish',
                description: 'Yashirin sonni topish',
                modes: ['solo', 'team'],
                difficulty: 4,
                folder: 'oyin8'
            },
            {
                id: 9,
                icon: '🧮',
                name: 'Hisoblash',
                description: 'Murakkab ifodalarni hisoblash',
                modes: ['solo', 'team'],
                difficulty: 4,
                folder: 'oyin9'
            },
            {
                id: 10,
                icon: '🧩',
                name: 'Matematik Jumboq',
                description: "Bo'sh katakchalarni to'ldirish",
                modes: ['solo', 'team'],
                difficulty: 4,
                folder: currentMode === 'solo' ? 'oyin19' : 'oyin10'
            },
            {
                id: 11,
                icon: '🔢',
                name: "Kasr O'yini",
                description: 'Kasrlar bilan amallar',
                modes: ['solo', 'team'],
                difficulty: 4,
                folder: currentMode === 'solo' ? 'oyin20' : 'oyin11'
            },
            {
                id: 12,
                icon: '🔄',
                name: 'Kasr va Foiz',
                description: "Kasrni foizga aylantirish",
                modes: ['solo'],
                difficulty: 4,
                folder: 'oyin12'
            },
            {
                id: 13,
                icon: '🎯',
                name: 'Nishonga Urish',
                description: 'Maqsad soniga yetish',
                modes: ['solo', 'team'],
                difficulty: 4,
                folder: currentMode === 'solo' ? 'oyin13' : 'oyin14'
            },
            {
                id: 14,
                icon: '📝',
                name: 'Matnli Masalalar',
                description: 'Hayotiy vaziyatlarni yechish',
                modes: ['solo', 'team'],
                difficulty: 4,
                folder: currentMode === 'solo' ? 'oyin15' : 'oyin16'
            },
            {
                id: 15,
                icon: '🔺',
                name: 'Shakl Tanish',
                description: 'Geometrik shakllarni tanish',
                modes: ['solo'],
                difficulty: 4,
                folder: 'oyin17'
            },
            {
                id: 16,
                icon: '🏆',
                name: 'Ustoz Rejimi',
                description: "Barcha mavzularni qamrab oluvchi",
                modes: ['solo'],
                difficulty: 4,
                folder: 'oyin18'
            }
        ];

        function loadGames() {
            const gamesGrid = document.getElementById('games-grid');
            gamesGrid.innerHTML = '';

            games.forEach(game => {
                const isAvailable = game.modes.includes(currentMode);
                const card = document.createElement('div');
                card.className = `game-card ${!isAvailable ? 'disabled' : ''}`;

                card.innerHTML = `
                    <span class="game-icon">${game.icon}</span>
                    <h3 class="game-title">${game.name}</h3>
                    <p class="game-description">${game.description}</p>
                    <div class="game-tags">
                        ${game.modes.includes('solo') ? '<span class="tag solo-tag">👤 Yolg\'iz</span>' : ''}
                        ${game.modes.includes('team') ? '<span class="tag team-tag">👥 Jamoa</span>' : ''}
                        <span class="tag">${game.difficulty} daraja</span>
                    </div>
                `;

                if (isAvailable) {
                    card.onclick = () => playGame(game);
                }

                gamesGrid.appendChild(card);
            });
        }

        function playGame(game) {
            // Update folder based on current mode for games that have different versions
            let folder = game.folder;
            if (game.id === 10) {
                folder = currentMode === 'solo' ? 'oyin19' : 'oyin10';
            } else if (game.id === 11) {
                folder = currentMode === 'solo' ? 'oyin20' : 'oyin11';
            } else if (game.id === 13) {
                folder = currentMode === 'solo' ? 'oyin13' : 'oyin14';
            } else if (game.id === 14) {
                folder = currentMode === 'solo' ? 'oyin15' : 'oyin16';
            }

            // Redirect to game page
            window.location.href = `${folder}/index.html`;
        }

        function closeModal() {
            document.getElementById('gameModal').classList.remove('active');
        }

        // Close modal on ESC key
        document.addEventListener('keydown', (e) => {
            if (e.key === 'Escape') {
                closeModal();
            }
        });

        // Close modal on outside click
        document.getElementById('gameModal').addEventListener('click', (e) => {
            if (e.target.id === 'gameModal') {
                closeModal();
            }
        });

        // Scroll to top functionality
        window.addEventListener('scroll', () => {
            const scrollTop = document.getElementById('scrollTop');
            if (window.pageYOffset > 300) {
                scrollTop.classList.add('visible');
            } else {
                scrollTop.classList.remove('visible');
            }
        });

        function scrollToTop() {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        }

        // Initialize
        document.addEventListener('DOMContentLoaded', () => {
            selectMode(currentMode);
        });
    </script>
</body>
</html>
