const gameState = { mode: 'solo', difficulty: 1, blueScore: 0, redScore: 0, soloScore: 0, targetScore: 10, currentProblem: { blue: null, red: null, solo: null }, currentAnswer: { blue: '', red: '', solo: '' } };
window.addEventListener('DOMContentLoaded', () => { const playMode = localStorage.getItem('playMode') || 'solo'; document.getElementById('gameMode').value = playMode; toggleTeamSetup(); });
function toggleTeamSetup() { const mode = document.getElementById('gameMode').value; document.getElementById('teamSetup').style.display = mode === 'team' ? 'block' : 'none'; }
function generateSequence() { const diff = parseInt(document.getElementById('difficulty').value); let step; switch(diff) { case 1: step = Math.floor(Math.random() * 3) + 1; break; case 2: step = Math.floor(Math.random() * 5) + 2; break; case 3: step = Math.floor(Math.random() * 10) + 5; break; case 4: step = Math.floor(Math.random() * 20) + 10; break; } const start = Math.floor(Math.random() * 20) + 1; const sequence = [start, start+step, start+step*2, start+step*3]; const answer = start+step*4; const question = `${sequence.join(', ')}, ?`; return { question, answer, sequence, step }; }
function displayProblem(team) { const problem = generateSequence(); gameState.currentProblem[team] = problem; gameState.currentAnswer[team] = ''; document.getElementById(`${team}Problem`).innerHTML = `<div class="problem-text">${problem.question}</div><div class="answer-input" id="${team}Answer">_</div>`; }
function createNumberPad(team) { const keyboardDiv = document.getElementById(`${team}Keyboard`); const buttons = ['7', '8', '9', '4', '5', '6', '1', '2', '3', '-', '0', 'C']; keyboardDiv.innerHTML = ''; buttons.forEach(btn => { const button = document.createElement('button'); button.className = 'number-btn'; if (btn === 'C') button.classList.add('clear-btn'); button.textContent = btn; button.onclick = () => handleNumberInput(team, btn); keyboardDiv.appendChild(button); }); const submitBtn = document.createElement('button'); submitBtn.className = 'number-btn submit-btn'; submitBtn.textContent = '✓ Javobni Yuborish'; submitBtn.onclick = () => submitAnswer(team); keyboardDiv.appendChild(submitBtn); }
function handleNumberInput(team, value) { if (value === 'C') { gameState.currentAnswer[team] = ''; } else if (value === '-') { if (gameState.currentAnswer[team] === '') { gameState.currentAnswer[team] = '-'; } } else { gameState.currentAnswer[team] += value; } document.getElementById(`${team}Answer`).textContent = gameState.currentAnswer[team] || '_'; }
function submitAnswer(team) { const userAnswer = parseInt(gameState.currentAnswer[team]); const correctAnswer = gameState.currentProblem[team].answer; if (isNaN(userAnswer)) { alert('Iltimos, javobni kiriting!'); return; } const problemDiv = document.getElementById(`${team}Problem`); if (userAnswer === correctAnswer) { problemDiv.classList.add('correct-answer'); setTimeout(() => problemDiv.classList.remove('correct-answer'), 500); if (team === 'solo') { gameState.soloScore++; document.getElementById('soloScore').textContent = gameState.soloScore; } else if (team === 'blue') { gameState.blueScore++; document.getElementById('blueScore').textContent = gameState.blueScore; } else if (team === 'red') { gameState.redScore++; document.getElementById('redScore').textContent = gameState.redScore; } if (checkWinner()) return; displayProblem(team); } else { problemDiv.classList.add('wrong-answer'); setTimeout(() => problemDiv.classList.remove('wrong-answer'), 500); gameState.currentAnswer[team] = ''; document.getElementById(`${team}Answer`).textContent = '_'; } }
function checkWinner() { if (gameState.mode === 'solo') { if (gameState.soloScore >= gameState.targetScore) { setTimeout(() => showResult('solo'), 500); return true; } } else { if (gameState.blueScore >= gameState.targetScore) { setTimeout(() => showResult('blue'), 500); return true; } if (gameState.redScore >= gameState.targetScore) { setTimeout(() => showResult('red'), 500); return true; } } return false; }
function startGame() { const mode = document.getElementById('gameMode').value; gameState.mode = mode; gameState.blueScore = 0; gameState.redScore = 0; gameState.soloScore = 0; if (mode === 'team') { const blueTeamName = document.getElementById('blueTeamName').value || "Ko'k Jamoa"; const redTeamName = document.getElementById('redTeamName').value || "Qizil Jamoa"; document.getElementById('blueTeamTitle').textContent = blueTeamName; document.getElementById('redTeamTitle').textContent = redTeamName; document.getElementById('soloGame').style.display = 'none'; document.getElementById('teamGame').style.display = 'block'; displayProblem('blue'); displayProblem('red'); createNumberPad('blue'); createNumberPad('red'); } else { document.getElementById('soloGame').style.display = 'block'; document.getElementById('teamGame').style.display = 'none'; displayProblem('solo'); createNumberPad('solo'); } document.getElementById('setupScreen').classList.remove('active'); document.getElementById('gameScreen').classList.add('active'); }
function showResult(winner) { const resultContent = document.getElementById('resultContent'); let html = ''; if (winner === 'solo') { html = `<div class="winner-emoji">🏆</div><div class="winner-text">Tabriklaymiz!</div><div class="result-stats"><div class="stat-row"><span class="stat-label">To'plangan Ball:</span><span class="stat-value">${gameState.soloScore}</span></div></div>`; } else { const winnerName = winner === 'blue' ? document.getElementById('blueTeamTitle').textContent : document.getElementById('redTeamTitle').textContent; html = `<div class="winner-emoji">🎉</div><div class="winner-text">${winnerName} G'OLIB!</div><div class="result-stats"><div class="stat-row"><span class="stat-label">${document.getElementById('blueTeamTitle').textContent}:</span><span class="stat-value">${gameState.blueScore} ball</span></div><div class="stat-row"><span class="stat-label">${document.getElementById('redTeamTitle').textContent}:</span><span class="stat-value">${gameState.redScore} ball</span></div></div>`; } resultContent.innerHTML = html; document.getElementById('gameScreen').classList.remove('active'); document.getElementById('resultScreen').classList.add('active'); }
function restartGame() { document.getElementById('resultScreen').classList.remove('active'); document.getElementById('setupScreen').classList.add('active'); }
function goHome() { window.location.href = '../index.php'; }
function pauseGame() { if (confirm('O\'yinni to\'xtatmoqchimisiz?')) { document.getElementById('gameScreen').classList.remove('active'); document.getElementById('setupScreen').classList.add('active'); } }
function showHelp() { document.getElementById('helpModal').classList.add('active'); }
function closeHelp() { document.getElementById('helpModal').classList.remove('active'); }
document.addEventListener('keydown', (e) => { if (e.key === 'Escape') closeHelp(); });
document.getElementById('helpModal').addEventListener('click', (e) => { if (e.target.id === 'helpModal') closeHelp(); });
