// Game State
const gameState = {
    operation: 'add',
    difficulty: 1,
    score: 0,
    currentProblem: null,
    currentAnswer: '',
    memoryTime: 3
};

// Generate math problem
function generateProblem() {
    const diff = parseInt(document.getElementById('difficulty').value);
    let min, max;

    switch(diff) {
        case 1: min = 1; max = 10; break;
        case 2: min = 10; max = 50; break;
        case 3: min = 50; max = 150; break;
        case 4: min = 100; max = 1000; break;
    }

    const operation = document.getElementById('operationType').value;
    let ops = [];

    if (operation === 'mixed') {
        ops = ['add', 'subtract', 'multiply', 'divide'];
    } else {
        ops = [operation];
    }

    const selectedOp = ops[Math.floor(Math.random() * ops.length)];
    let num1, num2, answer, question, symbol;

    switch(selectedOp) {
        case 'add':
            num1 = Math.floor(Math.random() * (max - min + 1)) + min;
            num2 = Math.floor(Math.random() * (max - min + 1)) + min;
            answer = num1 + num2;
            symbol = '+';
            break;
        case 'subtract':
            num1 = Math.floor(Math.random() * (max - min + 1)) + min;
            num2 = Math.floor(Math.random() * (max - min + 1)) + min;
            if (num1 < num2) [num1, num2] = [num2, num1];
            answer = num1 - num2;
            symbol = '-';
            break;
        case 'multiply':
            const multMax = Math.floor(Math.sqrt(max));
            num1 = Math.floor(Math.random() * multMax) + 1;
            num2 = Math.floor(Math.random() * multMax) + 1;
            answer = num1 * num2;
            symbol = '×';
            break;
        case 'divide':
            num2 = Math.floor(Math.random() * 10) + 1;
            answer = Math.floor(Math.random() * 20) + 1;
            num1 = num2 * answer;
            symbol = '÷';
            break;
    }

    question = `${num1} ${symbol} ${num2}`;
    return { question, answer };
}

// Show memory problem
function showMemoryProblem() {
    const problem = generateProblem();
    gameState.currentProblem = problem;
    gameState.currentAnswer = '';

    const expressionDiv = document.getElementById('expression');
    const countdownDiv = document.getElementById('countdown');
    const memoryDisplay = document.getElementById('memoryDisplay');
    const answerSection = document.getElementById('answerSection');

    expressionDiv.textContent = problem.question;
    expressionDiv.style.opacity = '1';
    countdownDiv.style.display = 'block';

    answerSection.style.display = 'none';

    let timeLeft = gameState.memoryTime;
    countdownDiv.textContent = timeLeft;

    const countdownInterval = setInterval(() => {
        timeLeft--;
        countdownDiv.textContent = timeLeft;

        if (timeLeft <= 0) {
            clearInterval(countdownInterval);
            hideExpression();
        }
    }, 1000);
}

// Hide expression and show answer input
function hideExpression() {
    const expressionDiv = document.getElementById('expression');
    const countdownDiv = document.getElementById('countdown');
    const answerSection = document.getElementById('answerSection');

    expressionDiv.style.opacity = '0';
    countdownDiv.style.display = 'none';

    setTimeout(() => {
        expressionDiv.textContent = '?';
        expressionDiv.style.opacity = '1';
        answerSection.style.display = 'block';
        document.getElementById('answer').textContent = '_';
    }, 500);
}

// Create number pad
function createNumberPad() {
    const keyboardDiv = document.getElementById('keyboard');
    const buttons = ['7', '8', '9', '4', '5', '6', '1', '2', '3', '-', '0', 'C'];

    keyboardDiv.innerHTML = '';

    buttons.forEach(btn => {
        const button = document.createElement('button');
        button.className = 'number-btn';
        if (btn === 'C') button.classList.add('clear-btn');
        button.textContent = btn;
        button.onclick = () => handleNumberInput(btn);
        keyboardDiv.appendChild(button);
    });

    const submitBtn = document.createElement('button');
    submitBtn.className = 'number-btn submit-btn';
    submitBtn.textContent = '✓ Javobni Yuborish';
    submitBtn.onclick = () => submitAnswer();
    keyboardDiv.appendChild(submitBtn);
}

// Handle number input
function handleNumberInput(value) {
    if (value === 'C') {
        gameState.currentAnswer = '';
    } else if (value === '-') {
        if (gameState.currentAnswer === '') {
            gameState.currentAnswer = '-';
        }
    } else {
        gameState.currentAnswer += value;
    }

    document.getElementById('answer').textContent = gameState.currentAnswer || '_';
}

// Submit answer
function submitAnswer() {
    const userAnswer = parseInt(gameState.currentAnswer);
    const correctAnswer = gameState.currentProblem.answer;

    if (isNaN(userAnswer)) {
        alert('Iltimos, javobni kiriting!');
        return;
    }

    const answerSection = document.getElementById('answerSection');

    if (userAnswer === correctAnswer) {
        answerSection.classList.add('correct-answer');
        setTimeout(() => answerSection.classList.remove('correct-answer'), 500);

        gameState.score++;
        document.getElementById('score').textContent = gameState.score;

        setTimeout(() => {
            showMemoryProblem();
        }, 1000);
    } else {
        answerSection.classList.add('wrong-answer');
        setTimeout(() => answerSection.classList.remove('wrong-answer'), 500);
        gameState.currentAnswer = '';
        document.getElementById('answer').textContent = '_';
    }
}

// Start game
function startGame() {
    const operation = document.getElementById('operationType').value;
    const difficulty = document.getElementById('difficulty').value;

    gameState.operation = operation;
    gameState.difficulty = difficulty;
    gameState.score = 0;

    document.getElementById('score').textContent = '0';

    createNumberPad();
    showMemoryProblem();

    document.getElementById('setupScreen').classList.remove('active');
    document.getElementById('gameScreen').classList.add('active');
}

// Restart game
function restartGame() {
    document.getElementById('resultScreen').classList.remove('active');
    document.getElementById('setupScreen').classList.add('active');
}

// Go home
function goHome() {
    window.location.href = '../index.php';
}

// Pause game
function pauseGame() {
    if (confirm('O\'yinni to\'xtatmoqchimisiz?')) {
        document.getElementById('gameScreen').classList.remove('active');
        document.getElementById('setupScreen').classList.add('active');
    }
}

// Show help
function showHelp() {
    document.getElementById('helpModal').classList.add('active');
}

// Close help
function closeHelp() {
    document.getElementById('helpModal').classList.remove('active');
}

// Close modal on ESC
document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape') {
        closeHelp();
    }
});

// Close modal on outside click
document.getElementById('helpModal').addEventListener('click', (e) => {
    if (e.target.id === 'helpModal') {
        closeHelp();
    }
});
