const gameState = { mode: 'solo', difficulty: 1, blueScore: 0, redScore: 0, soloScore: 0, targetScore: 10, currentProblem: { blue: null, red: null, solo: null }, currentAnswer: { blue: '', red: '', solo: '' } };
window.addEventListener('DOMContentLoaded', () => { const playMode = localStorage.getItem('playMode') || 'solo'; if(document.getElementById('gameMode')) { document.getElementById('gameMode').value = playMode; toggleTeamSetup(); } });
function toggleTeamSetup() { const mode = document.getElementById('gameMode').value; const teamSetup = document.getElementById('teamSetup'); if(teamSetup) teamSetup.style.display = mode === 'team' ? 'block' : 'none'; }
function generateProblem() { const diff = parseInt(document.getElementById('difficulty').value); let min, max; switch(diff) { case 1: min = 1; max = 10; break; case 2: min = 10; max = 50; break; case 3: min = 50; max = 150; break; case 4: min = 100; max = 1000; break; } const num1 = Math.floor(Math.random() * (max - min + 1)) + min; const num2 = Math.floor(Math.random() * (max - min + 1)) + min; const answer = num1 + num2; return { question: `${num1} + ${num2} = ?`, answer }; }
function displayProblem(team) { const problem = generateProblem(); gameState.currentProblem[team] = problem; gameState.currentAnswer[team] = ''; document.getElementById(`${team}Problem`).innerHTML = `<div class="problem-text">${problem.question}</div><div class="answer-input" id="${team}Answer">_</div>`; }
function createNumberPad(team) { const keyboardDiv = document.getElementById(`${team}Keyboard`); const buttons = ['7', '8', '9', '4', '5', '6', '1', '2', '3', '-', '0', 'C']; keyboardDiv.innerHTML = ''; buttons.forEach(btn => { const button = document.createElement('button'); button.className = 'number-btn'; if (btn === 'C') button.classList.add('clear-btn'); button.textContent = btn; button.onclick = () => handleNumberInput(team, btn); keyboardDiv.appendChild(button); }); const submitBtn = document.createElement('button'); submitBtn.className = 'number-btn submit-btn'; submitBtn.textContent = '✓ Javobni Yuborish'; submitBtn.onclick = () => submitAnswer(team); keyboardDiv.appendChild(submitBtn); }
function handleNumberInput(team, value) { if (value === 'C') { gameState.currentAnswer[team] = ''; } else if (value === '-') { if (gameState.currentAnswer[team] === '') gameState.currentAnswer[team] = '-'; } else { gameState.currentAnswer[team] += value; } document.getElementById(`${team}Answer`).textContent = gameState.currentAnswer[team] || '_'; }
function submitAnswer(team) { const userAnswer = parseInt(gameState.currentAnswer[team]); const correctAnswer = gameState.currentProblem[team].answer; if (isNaN(userAnswer)) { alert('Iltimos, javobni kiriting!'); return; } const problemDiv = document.getElementById(`${team}Problem`); if (userAnswer === correctAnswer) { problemDiv.classList.add('correct-answer'); setTimeout(() => problemDiv.classList.remove('correct-answer'), 500); if (team === 'solo') { gameState.soloScore++; document.getElementById('soloScore').textContent = gameState.soloScore; } else if (team === 'blue') { gameState.blueScore++; } else if (team === 'red') { gameState.redScore++; } if (checkWinner()) return; displayProblem(team); } else { problemDiv.classList.add('wrong-answer'); setTimeout(() => problemDiv.classList.remove('wrong-answer'), 500); gameState.currentAnswer[team] = ''; document.getElementById(`${team}Answer`).textContent = '_'; } }
function checkWinner() { if (gameState.mode === 'solo' && gameState.soloScore >= gameState.targetScore) { setTimeout(() => showResult('solo'), 500); return true; } return false; }
function startGame() { const mode = document.getElementById('gameMode') ? document.getElementById('gameMode').value : 'solo'; gameState.mode = mode; gameState.soloScore = 0; gameState.blueScore = 0; gameState.redScore = 0; if(document.getElementById('soloScore')) document.getElementById('soloScore').textContent = '0'; displayProblem('solo'); createNumberPad('solo'); document.getElementById('setupScreen').classList.remove('active'); document.getElementById('gameScreen').classList.add('active'); }
function showResult(winner) { const resultContent = document.getElementById('resultContent'); resultContent.innerHTML = `<div class="winner-emoji">🏆</div><div class="winner-text">Tabriklaymiz!</div><div class="result-stats"><div class="stat-row"><span class="stat-label">Ball:</span><span class="stat-value">${gameState.soloScore}</span></div></div>`; document.getElementById('gameScreen').classList.remove('active'); document.getElementById('resultScreen').classList.add('active'); }
function restartGame() { document.getElementById('resultScreen').classList.remove('active'); document.getElementById('setupScreen').classList.add('active'); }
function goHome() { window.location.href = '../index.php'; }
function pauseGame() { if (confirm('O\'yinni to\'xtatmoqchimisiz?')) { document.getElementById('gameScreen').classList.remove('active'); document.getElementById('setupScreen').classList.add('active'); } }
function showHelp() { document.getElementById('helpModal').classList.add('active'); }
function closeHelp() { document.getElementById('helpModal').classList.remove('active'); }
document.addEventListener('keydown', (e) => { if (e.key === 'Escape') closeHelp(); });
if(document.getElementById('helpModal')) { document.getElementById('helpModal').addEventListener('click', (e) => { if (e.target.id === 'helpModal') closeHelp(); }); }
